function [ xNormed, xOffsets, yNormed, yUnnormed, corrs, longCorr, rmse] = prepareSingleData( location )
%PREPAREDATA Summary of this function goes here
%   Detailed explanation goes here

load(location);

yNormed = dataMat(:,1);
yUnnormed = dataMat(:,1);
svrObs = dataMat(:,2:end);
xNormed = cell(numel(yNormed),1);

% Create correlations of the input with output
corrs = zeros(numel(yNormed), size(svrObs,2));

% the offsets are useful later on, when predicting
xOffsets = zeros(numel(yNormed), 1);

% concatenated data for an alternative correlation
xConcat = [];
yConcat = [];

for i=1:numel(yNormed)
    
    xNormed{i} = zeros(numel(yNormed{i}), size(svrObs,2));        
    
    xCat = zeros(numel(yNormed{i}), size(svrObs,2));
    
    for j=1:size(svrObs,2)
        
        % Due to the way predictor data was generated, some of them were
        % slightly shorter, make sure lengths are the same here
        if(numel(yNormed{i}) > numel(svrObs{i,j}))
            svrObs{i,j} = [svrObs{i,j}; zeros(numel(yNormed{i}) - numel(svrObs{i,j}),1)];
        elseif(numel(yNormed{i}) < numel(svrObs{i,j}))
            svrObs{i,j} = svrObs{i,j}(1:end - (numel(svrObs{i,j}) - numel(yNormed{i})));
        end
        xNormed{i}(:,j) = svrObs{i,j};
        
        % For correlation calcs
        xCat(:,j) = xNormed{i}(:,j);
        
        corrs(i,j) = corr(xNormed{i}(:,j), yNormed{i});
        
        xOffsets(i) = xOffsets(i) + mean(xNormed{i}(:,j));
        
        % normalise the predictors
        xNormed{i}(:,j) = xNormed{i}(:,j) - mean(xNormed{i}(:,j));
        xNormed{i}(:,j) = xNormed{i}(:,j) / std(xNormed{i}(:,j));
    end
    xConcat = cat(1, xConcat, xCat);
    
    yConcat = cat(1, yConcat, yNormed{i});
        
    % calculate the actual offset (Across all predictors)
    xOffsets(i) = xOffsets(i) / size(svrObs, 2);
    
    % normalise y as well
    yNormed{i} = yNormed{i} - mean(yNormed{i});
    yNormed{i} = yNormed{i} / std(yNormed{i});
end

longCorr = zeros(size(svrObs,2), 1);

for i=1:size(svrObs,2)
    longCorr(i) = corr(yConcat, xConcat(:,i));
end


rmse = sqrt( (1/numel(yConcat)) * sum((xConcat - repmat(yConcat,1,size(svrObs,2))).^2) );
% figure
% 
% plot([1:numel(yConcat)],xConcat,'b',[1:numel(yConcat)],yConcat,'g');
% title(sprintf('C %.2f', longCorr));
% set(gca, 'XTick', [], 'YTick', []);


end

